/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Storage;
import aeonics.manager.Config;
import aeonics.manager.Executor;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Snapshot;
import aeonics.template.Factory;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Functions;
import aeonics.util.Snapshotable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DefaultSnapshot
extends Manager<Snapshot> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Snapshot> template() {
        return super.template().summary("Persistent snapshot").description("Manages system snapshots in a specified local directory and stores data as separate JSON files for each plugin.").config(Snapshot.class, new Parameter("path").summary("Snapshot folder path").description("The path to the snapshot folder").format("text").optional(true).defaultValue((Object)"snapshots"));
    }

    private static class Implementation
    extends Snapshot {
        private Storage.Type store = null;

        private Implementation() {
        }

        private static void localSnapshot(Functions.Consumer<Data> consumer, Data data) throws Exception {
            consumer.accept((Object)data);
        }

        private static void localRestore(Functions.Consumer<Data> consumer, Data data) throws Exception {
            consumer.accept((Object)data);
        }

        public Executor.Task<String> create(String string) {
            if (this.store == null) {
                throw new IllegalStateException("Underlying storage is not set");
            }
            if (string == null) {
                string = "";
            }
            string = string.replaceAll("[^a-zA-Z0-9]", "");
            string = string.substring(0, Math.min(30, string.length()));
            ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("UTC"));
            String string2 = zonedDateTime.getYear() + "-" + (zonedDateTime.getMonthValue() < 10 ? "0" : "") + zonedDateTime.getMonthValue() + "-" + (zonedDateTime.getDayOfMonth() < 10 ? "0" : "") + zonedDateTime.getDayOfMonth() + "T" + (zonedDateTime.getHour() < 10 ? "0" : "") + zonedDateTime.getHour() + "-" + (zonedDateTime.getMinute() < 10 ? "0" : "") + zonedDateTime.getMinute() + "-" + (zonedDateTime.getSecond() < 10 ? "0" : "") + zonedDateTime.getSecond() + "Z";
            String string3 = string2 + "_" + string;
            ((Logger)Manager.of(Logger.class)).info(Snapshot.class, "Creating snapshot {}", new Object[]{string3});
            long l = System.currentTimeMillis();
            return ((Executor)Manager.of(Executor.class)).background(() -> {
                Thread.currentThread().setName(Thread.currentThread().getName() + " :: Snapshot");
                Data data = Data.map();
                for (Object object : createCallback) {
                    try {
                        if (!(object instanceof Snapshot.ModuleAwareBiConsumer)) {
                            throw new IllegalStateException("Invalid snapshot restore handler");
                        }
                        String string2 = ((Snapshot.ModuleAwareBiConsumer)object).origin().getModule().getName();
                        Data data2 = data.get(string2);
                        if (!data2.isMap()) {
                            data2 = Data.map();
                            data.put(string2, (Object)data2);
                        }
                        Implementation.localSnapshot((Functions.Consumer<Data>)object, data2);
                    }
                    catch (Exception exception) {
                        ((Logger)Manager.of(Logger.class)).warning(Snapshot.class, (Throwable)exception);
                    }
                }
                for (Object object : data.entrySet()) {
                    this.store.put(string3 + "/" + (String)object.getKey() + ".json", (Data)object.getValue());
                }
                long l2 = System.currentTimeMillis();
                ((Logger)Manager.of(Logger.class)).fine(Snapshot.class, (Object)("Snapshot creation completed in " + (l2 - l) + "ms"));
            }).then(() -> string3);
        }

        public Executor.Task<Void> restore(String string) {
            if (this.store == null) {
                throw new IllegalStateException("Underlying storage is not set");
            }
            if (!this.list().contains(string)) {
                throw new IllegalArgumentException("Invalid snapshot " + string);
            }
            ((Logger)Manager.of(Logger.class)).info(Snapshot.class, "Restoring snapshot {}", new Object[]{string});
            long l = System.currentTimeMillis();
            Collection collection = this.store.tree(string);
            if (collection == null || collection.size() == 0) {
                ((Logger)Manager.of(Logger.class)).fine(Snapshot.class, "Snapshot {} does not contain anything to restore", new Object[]{string});
                return ((Executor)Manager.of(Executor.class)).normalResolved((Object)null);
            }
            return ((Executor)Manager.of(Executor.class)).background(() -> {
                Thread.currentThread().setName(Thread.currentThread().getName() + " :: Restore");
                Data data = Data.map();
                for (Functions.Consumer consumer : restoreCallback) {
                    try {
                        if (!(consumer instanceof Snapshot.ModuleAwareBiConsumer)) {
                            throw new IllegalStateException("Invalid snapshot restore handler");
                        }
                        String string2 = ((Snapshot.ModuleAwareBiConsumer)consumer).origin().getModule().getName();
                        if (!collection.contains(string2 + ".json")) continue;
                        Data data2 = data.get(string2);
                        if (!data2.isMap()) {
                            data2 = this.store.getData(string + "/" + string2 + ".json");
                            data.put(string2, (Object)data2);
                        }
                        Implementation.localRestore((Functions.Consumer<Data>)consumer, data2);
                    }
                    catch (Exception exception) {
                        ((Logger)Manager.of(Logger.class)).warning(Snapshot.class, (Throwable)exception);
                    }
                }
                long l2 = System.currentTimeMillis();
                ((Logger)Manager.of(Logger.class)).fine(Snapshot.class, (Object)("Snapshot restoration completed in " + (l2 - l) + "ms"));
                ((Config)Manager.of(Config.class)).set(Snapshot.class, "current", (Object)string);
            });
        }

        public Collection<String> list() {
            if (this.store == null) {
                return Collections.emptyList();
            }
            return this.store.tree("").stream().filter(string -> string.endsWith("/")).map(string -> string.substring(0, string.length() - 1)).collect(Collectors.toList());
        }

        public void remove(String string) {
            if (this.store == null) {
                throw new IllegalStateException("Underlying storage is not set");
            }
            this.store.remove(string);
        }

        public boolean exists(String string) {
            if (this.store == null) {
                return false;
            }
            return this.store.tree("").contains(string + (string.endsWith("/") ? "" : "/"));
        }

        public void upload(byte[] byArray) {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                Path path;
                ZipEntry zipEntry;
                String string = null;
                try (ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);){
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        path = Paths.get(zipEntry.getName(), new String[0]).normalize();
                        if (path.getNameCount() >= 2) continue;
                        if (!zipEntry.isDirectory()) {
                            throw new IllegalArgumentException("The snapshot must contain only the root snapshot folder and no extra files on the side");
                        }
                        if (string != null) {
                            throw new IllegalArgumentException("The snapshot can only contain one root folder");
                        }
                        string = path.toString();
                    }
                    if (string == null) {
                        throw new IllegalArgumentException("The snapshot must contain one root folder with the snapshot content");
                    }
                    if (!string.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}-\\d{2}-\\d{2}Z_[a-zA-Z0-9]*")) {
                        throw new IllegalArgumentException("The snapshot root folder name is not valid");
                    }
                    if (this.exists(string)) {
                        throw new IllegalArgumentException("Duplicate snapshot name. Remove the old one before uploading.");
                    }
                }
                byteArrayInputStream.reset();
                zipInputStream = new ZipInputStream(byteArrayInputStream);
                try {
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        path = Paths.get(zipEntry.getName(), new String[0]).normalize();
                        if (path.getNameCount() < 2 || zipEntry.isDirectory()) continue;
                        this.store.put(path.toString(), zipInputStream.readAllBytes());
                    }
                }
                finally {
                    zipInputStream.close();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public byte[] download(String string) {
            if (this.store == null || !this.exists(string)) {
                throw new IllegalArgumentException("Invalid snapshot");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
                zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
                for (String string2 : this.store.list(string + "/")) {
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                    zipOutputStream.write(this.store.get(string2));
                }
                zipOutputStream.finish();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return byteArrayOutputStream.toByteArray();
        }

        public String latest() {
            if (this.store == null) {
                return null;
            }
            return this.store.tree("").stream().filter(string -> string.endsWith("/")).sorted(Comparator.reverseOrder()).map(string -> string.substring(0, string.length() - 1)).findFirst().orElse(null);
        }

        public void config(String string, Data data) {
            if (Config.implodeName(Snapshot.class, (String)"path").equals(string)) {
                try {
                    if (this.store == null) {
                        this.store = (Storage.Type)((Storage.Type)Factory.of(Storage.class).get(Storage.File.class).create(Data.map().put("parameters", (Object)Data.map().put("root", (Object)data)))).name("Snapshot storage").internal(true).snapshotMode(Snapshotable.SnapshotMode.NONE);
                    } else {
                        this.store.parameter("root", (Object)data);
                    }
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).warning(Snapshot.class, "Could not initialize destination storage {}", new Object[]{data});
                    ((Logger)Manager.of(Logger.class)).fine(Snapshot.class, (Throwable)exception);
                    this.store = null;
                }
            }
        }
    }
}

