/*
 * Decompiled with CFR 0.152.
 */
package aeonics.util;

import aeonics.data.Data;
import aeonics.manager.Config;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;

public class Hardware {
    private Hardware() {
    }

    public static Data export() {
        return Data.map().put("cpu", CPU.export()).put("ram", RAM.export());
    }

    public static class RAM {
        static final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();

        private RAM() {
        }

        public static void waitForSpace(long l, long l2) {
            long l3 = System.currentTimeMillis() + (l2 <= 0L ? 10000L : l2);
            long l4 = (long)((double)Heap.MAX * 0.85) - l;
            while (Heap.used() >= l4) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= l3) continue;
                Manager.of(Logger.class).severe(RAM.class, "Unable to acquire requested memory within {}ms. Max: {}, Used: {}, Limit: {}, Requested: {}", l2 <= 0L ? 10000L : l2, Heap.max(), Heap.used(), l4, l);
                if (l2 > 0L) break;
                throw new IllegalStateException("Not enough memory available");
            }
        }

        public static Data export() {
            return Data.map().put("heap", Heap.export()).put("nonheap", NonHeap.export()).put("physical", Physical.export());
        }

        public static class Physical {
            static long MAX = 0L;

            private Physical() {
            }

            public static long free() {
                try {
                    return (Long)CPU.os.getClass().getMethod("getFreeMemorySize", new Class[0]).invoke((Object)CPU.os, new Object[0]);
                }
                catch (Exception exception) {
                    try {
                        return (Long)CPU.os.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]).invoke((Object)CPU.os, new Object[0]);
                    }
                    catch (Exception exception2) {
                        return 0L;
                    }
                }
            }

            public static long max() {
                return MAX;
            }

            public static long process() {
                return CPU.os.getCommittedVirtualMemorySize();
            }

            public static Data export() {
                return Data.map().put("free", Physical.free()).put("max", Physical.max()).put("process", Physical.process());
            }

            static {
                try {
                    MAX = (Long)CPU.os.getClass().getMethod("getTotalMemorySize", new Class[0]).invoke((Object)CPU.os, new Object[0]);
                }
                catch (Exception exception) {
                    try {
                        MAX = (Long)CPU.os.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]).invoke((Object)CPU.os, new Object[0]);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }

        public static class NonHeap {
            static final long MAX = memory.getNonHeapMemoryUsage().getMax();

            private NonHeap() {
            }

            public static long used() {
                return memory.getNonHeapMemoryUsage().getUsed();
            }

            public static long max() {
                return MAX;
            }

            public static long committed() {
                return memory.getNonHeapMemoryUsage().getCommitted();
            }

            public static Data detail() {
                Data data = Data.list();
                for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (memoryPoolMXBean.getType() != MemoryType.NON_HEAP) continue;
                    MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                    data.add((Object)Data.map().put("name", memoryPoolMXBean.getName()).put("used", memoryUsage.getUsed()).put("max", memoryUsage.getMax()).put("committed", memoryUsage.getCommitted()));
                }
                return data;
            }

            public static Data export() {
                return Data.map().put("used", NonHeap.used()).put("max", NonHeap.max()).put("committed", NonHeap.committed()).put("detail", NonHeap.detail());
            }
        }

        public static class Heap {
            static final long MAX = memory.getHeapMemoryUsage().getMax();

            private Heap() {
            }

            public static long used() {
                return memory.getHeapMemoryUsage().getUsed();
            }

            public static long max() {
                return MAX;
            }

            public static long committed() {
                return memory.getHeapMemoryUsage().getCommitted();
            }

            public static Data detail() {
                Data data = Data.list();
                for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (memoryPoolMXBean.getType() != MemoryType.HEAP) continue;
                    MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                    data.add((Object)Data.map().put("name", memoryPoolMXBean.getName()).put("used", memoryUsage.getUsed()).put("max", memoryUsage.getMax()).put("committed", memoryUsage.getCommitted()));
                }
                return data;
            }

            public static Data export() {
                return Data.map().put("used", Heap.used()).put("max", Heap.max()).put("committed", Heap.committed()).put("detail", Heap.detail());
            }
        }
    }

    public static class CPU {
        static final OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        static final int CORES = os.getAvailableProcessors();
        private static int limit = -1;
        static final long PID = ProcessHandle.current().pid();

        private CPU() {
        }

        public static double load() {
            return os.getProcessCpuLoad();
        }

        public static double system() {
            try {
                return (Double)os.getClass().getMethod("getCpuLoad", new Class[0]).invoke((Object)os, new Object[0]);
            }
            catch (Exception exception) {
                try {
                    return (Double)os.getClass().getMethod("getSystemCpuLoad", new Class[0]).invoke((Object)os, new Object[0]);
                }
                catch (Exception exception2) {
                    return 0.0;
                }
            }
        }

        public static int cores() {
            return CORES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int limit() {
            if (limit > 0) {
                return limit;
            }
            Class<CPU> clazz = CPU.class;
            synchronized (CPU.class) {
                if (limit > 0) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return limit;
                }
                Object object = null;
                if (Manager.of(Config.class) != null) {
                    object = Manager.of(Config.class).get("AEONICS_HARDWARE_CPU_LIMIT").asString();
                }
                if (object == null || ((String)object).isBlank()) {
                    object = System.getProperty("AEONICS_HARDWARE_CPU_LIMIT");
                }
                if (object == null || ((String)object).isBlank()) {
                    object = System.getenv("AEONICS_HARDWARE_CPU_LIMIT");
                }
                if (object == null || ((String)object).isBlank()) {
                    object = "" + Runtime.getRuntime().availableProcessors();
                }
                try {
                    Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    object = "" + Runtime.getRuntime().availableProcessors();
                }
                limit = Integer.parseInt((String)object);
                System.setProperty("AEONICS_HARDWARE_CPU_LIMIT", "" + limit);
                // ** MonitorExit[var0] (shouldn't be in output)
                return limit;
            }
        }

        public static long pid() {
            return PID;
        }

        public static Data export() {
            return Data.map().put("process", CPU.load()).put("system", CPU.system()).put("cores", CPU.cores()).put("limit", CPU.limit()).put("pid", CPU.pid());
        }
    }
}

