/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.manager.Manager;
import aeonics.template.Parameter;
import aeonics.util.Functions;
import aeonics.util.Tuples;
import java.util.Map;

public abstract class Config
extends Manager.Type {
    public static final String sanitize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                stringBuilder.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                stringBuilder.append((char)(c + 32));
                continue;
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    @Override
    public final Class<? extends Manager.Type> manager() {
        return Config.class;
    }

    public static Config get() {
        return Manager.of(Config.class);
    }

    public static String implodeName(Class<?> clazz, String string) {
        return Config.implodeName(Config.sanitize(clazz.getName()), string);
    }

    public static String implodeName(String string, String string2) {
        return Config.sanitize(string) + ":" + Config.sanitize(string2);
    }

    public static String implodeName(Tuples.Tuple<String, String> tuple) {
        return (String)tuple.a + ":" + (String)tuple.b;
    }

    public static Tuples.Tuple<String, String> explodeName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            n = string.lastIndexOf(46);
        }
        if (n < 0) {
            return Tuples.Tuple.of("system", Config.sanitize(string));
        }
        return Tuples.Tuple.of(Config.sanitize(string.substring(0, n)), Config.sanitize(string.substring(n + 1)));
    }

    public abstract void declare(String var1, Parameter var2);

    public void declare(Class<?> clazz, Parameter parameter) {
        this.declare(clazz.getName(), parameter);
    }

    public abstract Parameter definition(String var1, String var2);

    public Parameter definition(Class<?> clazz, String string) {
        return this.definition(clazz.getName(), string);
    }

    public Parameter definition(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        Tuples.Tuple<String, String> tuple = Config.explodeName(string);
        return this.definition((String)tuple.a, (String)tuple.b);
    }

    public abstract Data get(String var1, String var2);

    public Data get(Class<?> clazz, String string) {
        return this.get(clazz.getName(), string);
    }

    public Data get(Entity entity, String string) {
        return this.get(entity.type(), string);
    }

    public Data get(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        Tuples.Tuple<String, String> tuple = Config.explodeName(string);
        return this.get((String)tuple.a, (String)tuple.b);
    }

    public abstract boolean contains(String var1, String var2);

    public boolean contains(Class<?> clazz, String string) {
        return this.contains(clazz.getName(), string);
    }

    public boolean contains(Entity entity, String string) {
        return this.contains(entity.type(), string);
    }

    public boolean contains(String string) {
        if (string == null || string.isBlank()) {
            return false;
        }
        Tuples.Tuple<String, String> tuple = Config.explodeName(string);
        return this.contains((String)tuple.a, (String)tuple.b);
    }

    public abstract Data set(String var1, String var2, Object var3);

    public Data set(Class<?> clazz, String string, Object object) {
        return this.set(clazz.getName(), string, object);
    }

    public Data set(Entity entity, String string, Object object) {
        return this.set(entity.type(), string, object);
    }

    public Data set(String string, Object object) {
        if (string == null || string.isBlank()) {
            return null;
        }
        Tuples.Tuple<String, String> tuple = Config.explodeName(string);
        return this.set((String)tuple.a, (String)tuple.b, object);
    }

    public abstract Data remove(String var1, String var2);

    public Data remove(Class<?> clazz, String string) {
        return this.remove(clazz.getName(), string);
    }

    public Data remove(Entity entity, String string) {
        return this.remove(entity.type(), string);
    }

    public Data remove(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        Tuples.Tuple<String, String> tuple = Config.explodeName(string);
        return this.remove((String)tuple.a, (String)tuple.b);
    }

    public void watch(String string, Functions.BiConsumer<String, Data> biConsumer) {
        if (string == null || string.isBlank()) {
            return;
        }
        Tuples.Tuple<String, String> tuple = Config.explodeName(string);
        this.watch((String)tuple.a, (String)tuple.b, biConsumer);
    }

    public void watch(Class<?> clazz, String string, Functions.BiConsumer<String, Data> biConsumer) {
        this.watch(clazz.getName(), string, biConsumer);
    }

    public void watch(Entity entity, String string, Functions.BiConsumer<String, Data> biConsumer) {
        this.watch(entity.type(), string, biConsumer);
    }

    public abstract void watch(String var1, String var2, Functions.BiConsumer<String, Data> var3);

    public abstract Map<String, Data> all(String var1);

    public Map<String, Data> all(Class<?> clazz) {
        return this.all(clazz.getName());
    }

    public Map<String, Data> all(Entity entity) {
        return this.all(entity.type());
    }

    public abstract Map<String, Map<String, Data>> all();
}

