/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Registry;
import aeonics.entity.security.Group;
import aeonics.entity.security.Role;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.Json;
import aeonics.util.Snapshotable;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.util.function.Supplier;

public class User
extends Item<Type> {
    public static final Type ANONYMOUS = (Type)((Entity)((Entity)new User().template().create(Data.map().put("id", "10000000-1100000000000000")).name("ANONYMOUS")).internal(true)).snapshotMode(Snapshotable.SnapshotMode.UPDATE);
    public static final Type SYSTEM = (Type)((Entity)((Entity)new User().template().create(Data.map().put("id", "10000000-1200000000000000")).name("SYSTEM")).internal(true)).snapshotMode(Snapshotable.SnapshotMode.UPDATE);

    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    protected Class<? extends User> category() {
        return User.class;
    }

    @Override
    public Template<? extends Type> template() {
        return ((Template)((Template)((Template)((Template)((Template)((Template)super.template().summary("User")).description("Users represents a login to the system and can be linked to groups and roles. Users can only login if they are supported by a security provider.")).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("active").summary("Active")).description("Whether or not this user is active")).rule(Parameter.Rule.BOOLEAN).format("boolean")).optional(true).defaultValue(true))).add(((Parameter)((Parameter)((Parameter)new Parameter("login").summary("Login")).description("The login name used for authentication. If the login is not set, the user cannot login.")).format("text")).optional(true))).add((Parameter)((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("attributes").summary("Attributes")).description("Additional user attributes in the form of a data map.")).rule(Parameter.Rule.JSON_MAP).format("json")).optional(true).defaultValue(Data.map())).validator(data -> data != null && (data.isMap() || Json.decode(data.asString()).isMap())))).add((Relationship)((Relationship)((Relationship)new Relationship("roles").category(Role.class)).summary("Roles")).description("List of user roles."))).add((Relationship)((Relationship)((Relationship)new Relationship("groups").category(Group.class)).summary("Groups")).description("List of user groups."));
    }

    public static class Type
    extends Entity {
        public String login() {
            return this.valueOf("login").asString();
        }

        public boolean active() {
            return this.valueOf("active").asBool();
        }

        @Override
        public final String category() {
            return StringUtils.toLowerCase(User.class);
        }

        public boolean isMemberOf(String string) {
            Group.Type type = (Group.Type)Registry.of(Group.class).get(string);
            if (type == null) {
                return false;
            }
            return this.isMemberOf(type);
        }

        public boolean isMemberOf(Group.Type type) {
            if (type == null) {
                return false;
            }
            for (Tuples.Tuple tuple : this.relations("groups")) {
                if (!type.equals(tuple.a)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRole(String string) {
            Role.Type type = (Role.Type)Registry.of(Role.class).get(string);
            if (type == null) {
                return false;
            }
            return this.hasRole(type);
        }

        public boolean hasRole(Role.Type type) {
            if (type == null) {
                return false;
            }
            for (Tuples.Tuple tuple : this.relations("roles")) {
                if (!type.equals(tuple.a)) continue;
                return true;
            }
            for (Tuples.Tuple tuple : this.relations("groups")) {
                for (Tuples.Tuple tuple2 : ((Entity)tuple.a).relations("roles")) {
                    if (!type.equals(tuple2.a)) continue;
                    return true;
                }
            }
            return false;
        }

        public Data attributes() {
            return this.valueOf("attributes");
        }
    }
}

